/*
 * Decompiled with CFR 0.152.
 */
package org.zefer.pd4ml.taglib;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.zefer.pd4ml.PD4Constants;
import org.zefer.pd4ml.PD4ML;
import org.zefer.pd4ml.PD4PageMark;
import org.zefer.pd4ml.taglib.PD4SavedRequest;

public class PD4MLTransformerTag
extends BodyTagSupport {
    private static final long serialVersionUID = -2959199397920243777L;
    public static final String CACHED_RESPONSE_KEY = "pd4cached";
    public static final String DISPOSITION_PARAM = "pd4disposition";
    public static final String FILENAME_PARAM = "pd4filename";
    private PD4SavedRequest req = new PD4SavedRequest();
    private String forward = null;
    private boolean enable = true;
    public String http;
    private File savePdfToFile;
    private String redirectToSavedFile;
    private String redirectMethod;
    public boolean forceCaching = false;

    public void release() {
        super.release();
        this.savePdfToFile = null;
        this.redirectMethod = null;
        this.redirectToSavedFile = null;
        this.forward = null;
        if (this.req != null) {
            this.req.header = null;
            this.req.footer = null;
        }
        this.req = new PD4SavedRequest();
    }

    public int doStartTag() throws JspException {
        super.doStartTag();
        this.savePdfToFile = null;
        this.redirectMethod = null;
        this.redirectToSavedFile = null;
        this.forward = null;
        if (this.enable) {
            ServletResponse servletResponse = this.pageContext.getResponse();
            servletResponse.reset();
            if (this.forward == null && !"noheader".equalsIgnoreCase(this.http)) {
                if ("rtf".equalsIgnoreCase(this.req.outputFormat) || "rtfwmf".equalsIgnoreCase(this.req.outputFormat)) {
                    servletResponse.setContentType("application/rtf");
                } else if ("png8".equalsIgnoreCase(this.req.outputFormat) || "png24".equalsIgnoreCase(this.req.outputFormat)) {
                    servletResponse.setContentType("image/png");
                } else if ("tiff".equalsIgnoreCase(this.req.outputFormat) || "tiffcomp".equalsIgnoreCase(this.req.outputFormat)) {
                    servletResponse.setContentType("image/tiff");
                } else {
                    servletResponse.setContentType("application/pdf");
                }
                if (servletResponse instanceof HttpServletResponse) {
                    String string = (this.req.inline ? "inline" : "attachment") + "; filename=" + this.req.fileName;
                    ((HttpServletResponse)servletResponse).setHeader("Content-disposition", string);
                    ((HttpServletResponse)servletResponse).setHeader("Pragma", "cache");
                    ((HttpServletResponse)servletResponse).setHeader("Expires", "0");
                    ((HttpServletResponse)servletResponse).setHeader("Cache-control", "private");
                }
            }
        } else {
            return 1;
        }
        this.pageContext.setAttribute("pd4ml.transformer.tag", (Object)this, 2);
        return 2;
    }

    public int doEndTag() throws JspException {
        BodyContent bodyContent;
        if (!this.enable) {
            return 5;
        }
        if (this.pageContext.getSession() != null) {
            this.req.sessionID = this.pageContext.getSession().getId();
        }
        if ((bodyContent = this.getBodyContent()) != null) {
            this.req.generatedHtml = bodyContent.getString();
        } else {
            this.req.generatedHtml = "";
            this.debug("empty body");
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
        HttpServletResponse httpServletResponse = (HttpServletResponse)this.pageContext.getResponse();
        if (this.enable) {
            Object object;
            if (httpServletResponse instanceof HttpServletResponse) {
                object = (this.req.inline ? "inline" : "attachment") + "; filename=" + this.req.fileName;
                httpServletResponse.setHeader("Content-disposition", (String)object);
            }
            this.req.servletPath = this.pageContext.getServletContext().getRealPath(((HttpServletRequest)this.pageContext.getRequest()).getServletPath());
            if (this.req.url != null) {
                if (this.req.url.startsWith("/") && !this.req.url.toLowerCase().startsWith("http://")) {
                    object = this.pageContext.getRequest().getServerName() + ":" + this.pageContext.getRequest().getServerPort();
                    this.req.url = "http://" + (String)object + this.req.url;
                }
                if (null != (object = this.pageContext.getRequest().getParameter("pd4session"))) {
                    int n = this.req.url.indexOf("?");
                    this.req.url = n >= 0 ? this.req.url.substring(0, n) + ";jsessionid=" + (String)object + this.req.url.substring(n) : this.req.url + ";jsessionid=" + (String)object;
                }
            }
            object = null;
            try {
                object = PD4MLTransformerTag.render(this.req, this.pageContext.getServletContext(), httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                throw new JspException((Throwable)exception);
            }
            if (this.savePdfToFile != null) {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(this.savePdfToFile);
                    fileOutputStream.write((byte[])object);
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    throw new JspException((Throwable)exception);
                }
            }
            if (this.redirectToSavedFile != null) {
                String string = httpServletResponse.encodeRedirectURL(this.redirectToSavedFile);
                if (this.redirectMethod != null && "forward".equalsIgnoreCase(this.redirectMethod)) {
                    if (this.req.debug) {
                        System.out.println("forwarding to [" + this.redirectToSavedFile + "]");
                    }
                    try {
                        this.pageContext.getRequest().getRequestDispatcher(string).forward(this.pageContext.getRequest(), (ServletResponse)httpServletResponse);
                        return 5;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                        throw new JspException("can not forward to " + this.redirectToSavedFile);
                    }
                }
                if (this.req.debug) {
                    System.out.println("sending redirect to [" + this.redirectToSavedFile + "]");
                }
                try {
                    httpServletResponse.sendRedirect(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                    throw new JspException("can not redirect to " + this.redirectToSavedFile);
                }
                return 5;
            }
            if (this.forward == null) {
                try {
                    httpServletResponse.setContentLength(((Object)object).length);
                    ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                    if (this.getEncoding() != null && this.getEncoding().equals("default")) {
                        servletOutputStream.write((byte[])object);
                    } else {
                        servletOutputStream.print(new String((byte[])object, "ISO8859_1"));
                    }
                    servletOutputStream.flush();
                    servletOutputStream.close();
                }
                catch (IOException iOException) {
                }
                catch (Exception exception) {
                    throw new JspException((Throwable)exception);
                }
            } else {
                String string;
                String string2 = "PD4" + System.currentTimeMillis();
                this.pageContext.setAttribute(string2, (Object)this.req, 3);
                String string3 = this.forward;
                if (this.forward.startsWith("/") && !this.forward.toLowerCase().startsWith("http://")) {
                    string = this.pageContext.getRequest().getServerName() + ":" + this.pageContext.getRequest().getServerPort();
                    string3 = "http://" + string + this.forward;
                }
                string = this.req.inline ? "inline" : "attachment";
                StringBuffer stringBuffer = new StringBuffer("?");
                stringBuffer.append(CACHED_RESPONSE_KEY).append('=').append(string2);
                stringBuffer.append('&');
                stringBuffer.append(DISPOSITION_PARAM).append('=').append(string);
                stringBuffer.append('&');
                stringBuffer.append(FILENAME_PARAM).append('=').append(this.req.fileName);
                String string4 = httpServletResponse.encodeRedirectURL(string3 + stringBuffer);
                try {
                    httpServletResponse.sendRedirect(string4);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                    throw new JspException("can not redirect to " + string3);
                }
            }
        } else {
            httpServletResponse.setContentLength(this.req.generatedHtml.length());
            try {
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                servletOutputStream.print(this.req.generatedHtml);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 5;
    }

    private void debug(String string) {
        if (this.req.debug) {
            System.out.println(string);
        }
    }

    public static byte[] render(PD4SavedRequest pD4SavedRequest, ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream;
        block54: {
            int n;
            int n2;
            Object object;
            Object object2;
            PD4ML pD4ML = new PD4ML();
            pD4ML.useServletContext(servletContext);
            pD4ML.useHttpRequest(httpServletRequest, httpServletResponse);
            pD4ML.setSessionID(pD4SavedRequest.sessionID);
            try {
                object2 = PD4Constants.class;
                object = ((Class)object2).getField(pD4SavedRequest.pageFormat);
                Dimension dimension = (Dimension)((Field)object).get(pD4ML);
                if (pD4SavedRequest.landscape) {
                    dimension = pD4ML.changePageOrientation(dimension);
                }
                pD4ML.setPageSize(dimension);
            }
            catch (Exception exception) {
                object = new StringTokenizer(pD4SavedRequest.pageFormat, "x");
                try {
                    int n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
                    n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
                    if (n2 < 1 || n3 < 1) {
                        throw new Exception("nop");
                    }
                    Dimension dimension = new Dimension(n3, n2);
                    if (pD4SavedRequest.landscape) {
                        dimension = pD4ML.changePageOrientation(dimension);
                    }
                    pD4ML.setPageSize(dimension);
                }
                catch (Exception exception2) {
                    throw new JspTagException("Invalid page format: " + pD4SavedRequest.pageFormat);
                }
            }
            object2 = new StringTokenizer(pD4SavedRequest.pageInsets, ",");
            try {
                int n4 = Integer.parseInt(((StringTokenizer)object2).nextToken());
                n = Integer.parseInt(((StringTokenizer)object2).nextToken());
                n2 = Integer.parseInt(((StringTokenizer)object2).nextToken());
                int n5 = Integer.parseInt(((StringTokenizer)object2).nextToken());
                String string = ((StringTokenizer)object2).nextToken();
                Insets insets = new Insets(n4, n, n2, n5);
                if ("mm".equalsIgnoreCase(string)) {
                    pD4ML.setPageInsetsMM(insets);
                } else {
                    pD4ML.setPageInsets(insets);
                }
            }
            catch (Exception exception) {
                throw new Exception("Invalid page insets (top, left, bottom, right, units): " + pD4SavedRequest.pageInsets);
            }
            if (pD4SavedRequest.multicolumn != null) {
                String string = pD4SavedRequest.multicolumn.trim();
                n = string.indexOf(44);
                try {
                    if (n < 0) {
                        throw new Exception();
                    }
                    n2 = Integer.parseInt(string.substring(0, n));
                    String string2 = string.substring(string.length() - 2);
                    boolean bl = false;
                    if ("mm".equalsIgnoreCase(string2)) {
                        bl = true;
                        string = string.substring(0, string.length() - 2);
                    }
                    if ("pt".equalsIgnoreCase(string2)) {
                        string = string.substring(0, string.length() - 2);
                    }
                    int n6 = Integer.parseInt(string.substring(n + 1));
                    pD4ML.generateMulticolumn(n2, n6, bl);
                }
                catch (Exception exception) {
                    throw new Exception("Invalid multicolumn definition (columns,gap): " + pD4SavedRequest.multicolumn + "\nExample: '3,10mm' or '2,25pt'");
                }
            }
            try {
                int n7 = Integer.parseInt(pD4SavedRequest.screenWidth);
                pD4ML.setHtmlWidth(n7);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("Invalid screen width: " + pD4SavedRequest.screenWidth);
            }
            if (pD4SavedRequest.adjustHtmlWidth) {
                pD4ML.adjustHtmlWidth();
            }
            pD4ML.enableImgSplit(pD4SavedRequest.enableImageSplit);
            pD4ML.generatePdfa(pD4SavedRequest.pdfa);
            if (pD4SavedRequest.dynamicParams != null) {
                pD4ML.setDynamicParams(pD4SavedRequest.dynamicParams);
            }
            pD4ML.setAuthorName(pD4SavedRequest.authorName);
            pD4ML.interpolateImages(pD4SavedRequest.interpolateImages);
            if (pD4SavedRequest.debug) {
                pD4ML.enableDebugInfo();
            }
            if (pD4SavedRequest.outlineHeadings) {
                pD4ML.generateOutlines(true);
            } else if (pD4SavedRequest.outlineNamedAnchors) {
                pD4ML.generateOutlines(false);
            }
            if (!pD4SavedRequest.generateHyperlinks) {
                pD4ML.disableHyperlinks();
            }
            if (pD4SavedRequest.protectPhysicalUnitDimensions) {
                pD4ML.protectPhysicalUnitDimensions();
            }
            if (pD4SavedRequest.outputFormat != null) {
                pD4ML.outputFormat(pD4SavedRequest.outputFormat);
            }
            if (pD4SavedRequest.outputRange != null) {
                pD4ML.outputRange(pD4SavedRequest.outputRange);
            }
            if (pD4SavedRequest.fitPageVertically) {
                pD4ML.fitPageVertically();
            }
            pD4ML.enableSmartTableBreaks(pD4SavedRequest.tableBreaks);
            pD4ML.generatePdfForms(pD4SavedRequest.generatePdfForms, null);
            pD4ML.setPermissions(pD4SavedRequest.password, pD4SavedRequest.permissions, pD4SavedRequest.strong);
            if (pD4SavedRequest.embedTtfFrom != null) {
                try {
                    pD4ML.useTTF(pD4SavedRequest.embedTtfFrom, pD4SavedRequest.embed);
                    pD4ML.setDefaultTTFs(pD4SavedRequest.defaultSerif, pD4SavedRequest.defaultSansSerif, pD4SavedRequest.defaultMonospace);
                }
                catch (IOException iOException) {
                    throw new Exception(iOException.getMessage());
                }
            }
            if (pD4SavedRequest.header != null) {
                if (!PD4ML.isDemoMode()) {
                    pD4SavedRequest.header.setTitleTemplate("pd4ml evaluation copy. visit http://pd4ml.zefer.org");
                    pD4SavedRequest.header.setPagesToSkip(0);
                }
                pD4ML.setPageHeader(pD4SavedRequest.header);
            }
            if (!PD4ML.isDemoMode() && pD4SavedRequest.header == null) {
                PD4PageMark pD4PageMark = new PD4PageMark();
                pD4PageMark.setTitleAlignment(0);
                pD4PageMark.setTitleTemplate("pd4ml evaluation copy. visit http://pd4ml.zefer.org");
                pD4PageMark.setColor(Color.lightGray);
                pD4PageMark.setAreaHeight(25);
                pD4ML.setPageHeader(pD4PageMark);
            }
            if (pD4SavedRequest.footer != null) {
                pD4ML.setPageFooter(pD4SavedRequest.footer);
            }
            URL uRL = null;
            try {
                uRL = new URL("file:.");
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace(System.err);
            }
            try {
                uRL = new URL("file:" + pD4SavedRequest.servletPath);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace(System.err);
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                if (pD4SavedRequest.url != null) {
                    if (pD4SavedRequest.debug) {
                        System.err.println("request: " + pD4SavedRequest.url);
                    }
                    if (!pD4SavedRequest.url.toLowerCase().startsWith("http://")) {
                        StringReader stringReader = new StringReader("invalid url: " + pD4SavedRequest.url);
                        pD4ML.render(stringReader, (OutputStream)byteArrayOutputStream, uRL);
                    } else {
                        pD4ML.render(pD4SavedRequest.url, (OutputStream)byteArrayOutputStream);
                    }
                    break block54;
                }
                StringReader stringReader = new StringReader(pD4SavedRequest.generatedHtml);
                if (pD4SavedRequest.encoding == null) {
                    pD4SavedRequest.encoding = "utf8";
                }
                try {
                    pD4ML.addStyle("CALLEDFROMTAGLIB{}", true);
                    pD4ML.render(stringReader, (OutputStream)byteArrayOutputStream, uRL, pD4SavedRequest.encoding);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    System.err.println("please increase heap size of JVM with the command-line parameter -Xmx512m");
                    outOfMemoryError.printStackTrace(System.err);
                    throw outOfMemoryError;
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                    throw exception;
                }
            }
            catch (InvalidParameterException invalidParameterException) {
                StringReader stringReader = new StringReader(invalidParameterException.toString());
                try {
                    pD4ML.render(stringReader, (OutputStream)byteArrayOutputStream, uRL);
                }
                catch (InvalidParameterException invalidParameterException2) {
                    invalidParameterException2.printStackTrace(System.err);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                }
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String getHttp() {
        return this.http;
    }

    public void setHttp(String string) {
        this.http = string;
    }

    public String getOutline() {
        if (this.req.outlineNamedAnchors) {
            return "anchors";
        }
        if (this.req.outlineHeadings) {
            return "headings";
        }
        return "none";
    }

    public String getGenerateHyperlinks() {
        return this.req.generateHyperlinks ? "true" : "false";
    }

    public String getDebug() {
        return this.req.debug ? "true" : "false";
    }

    public String getUseAFM() {
        return this.req.useAFM ? "true" : "false";
    }

    public String getEnableImageSplit() {
        return this.req.enableImageSplit ? "true" : "false";
    }

    public String getPdfa() {
        return this.req.pdfa ? "true" : "false";
    }

    public String getEnableSwingPatch() {
        return this.req.enableSwingPatch ? "true" : "false";
    }

    public String getInterpolateImages() {
        return this.req.interpolateImages ? "true" : "false";
    }

    public void setDynamicParams(Map map) {
        this.req.dynamicParams = map;
    }

    public String getEncoding() {
        return this.req.encoding;
    }

    public String getPageFormat() {
        return this.req.pageFormat;
    }

    public String getFileName() {
        return this.req.fileName;
    }

    public String getInline() {
        return this.req.inline ? "true" : "false";
    }

    public String getPageInsets() {
        return this.req.pageInsets;
    }

    public String getPageOrientation() {
        return this.req.landscape ? "landscape" : "portrait";
    }

    public String getScreenWidth() {
        return this.req.screenWidth;
    }

    public String getUrl() {
        return this.req.url;
    }

    public String getFroward() {
        return this.forward;
    }

    public String getEnableTableBreaks() {
        return "" + this.req.tableBreaks;
    }

    public boolean isAdjustScreenWidth() {
        return this.req.adjustHtmlWidth;
    }

    public void setAdjustScreenWidth(boolean bl) {
        this.req.adjustHtmlWidth = bl;
    }

    public void setEnableTableBreaks(String string) {
        this.req.tableBreaks = string != null && string.equalsIgnoreCase("true");
    }

    public void setForward(String string) {
        this.forward = string;
        if (string != null && string.trim().length() == 0) {
            this.forward = null;
        }
    }

    public void setUrl(String string) {
        this.req.url = string;
    }

    public void setEnableImageSplit(String string) {
        this.req.enableImageSplit = string != null && string.equalsIgnoreCase("true");
    }

    public void setPdfa(String string) {
        this.req.pdfa = string != null && string.equalsIgnoreCase("true");
    }

    public void setDebug(String string) {
        this.req.debug = string != null && string.equalsIgnoreCase("true");
    }

    public void setUseAFM(String string) {
        this.req.useAFM = string == null || !string.equalsIgnoreCase("false");
    }

    public void setEmbedTtfFrom(String string, boolean bl) {
        this.req.embedTtfFrom = string;
        this.req.embed = bl;
    }

    public void setGenerateHyperlinks(String string) {
        this.req.generateHyperlinks = string != null && string.equalsIgnoreCase("true");
    }

    public void setOutline(String string) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("anchors")) {
            this.req.outlineNamedAnchors = true;
            this.req.outlineHeadings = false;
            return;
        }
        if (string.equalsIgnoreCase("headings")) {
            this.req.outlineHeadings = true;
            this.req.outlineNamedAnchors = false;
        }
    }

    public void setEnableSwingPatch(String string) {
        this.req.enableSwingPatch = string != null && string.equalsIgnoreCase("true");
    }

    public void setInterpolateImages(String string) {
        this.req.interpolateImages = string != null && string.equalsIgnoreCase("true");
    }

    public void setEncoding(String string) {
        this.req.encoding = string;
    }

    public void setPageFormat(String string) {
        this.req.pageFormat = string;
    }

    public void setPageInsets(String string) {
        this.req.pageInsets = string;
    }

    public void setFileName(String string) {
        this.req.fileName = string == null ? null : string.replace(' ', '_');
    }

    public void setInline(String string) {
        this.req.inline = string != null && string.equalsIgnoreCase("true");
    }

    public void setPageOrientation(String string) {
        this.req.landscape = string != null && string.equalsIgnoreCase("landscape");
    }

    public void setScreenWidth(String string) {
        this.req.screenWidth = string;
    }

    public String getAuthorName() {
        return this.req.authorName;
    }

    public void setAuthorName(String string) {
        this.req.authorName = string;
    }

    public String getGeneratePdfForms() {
        return "" + this.req.generatePdfForms;
    }

    public void setGeneratePdfForms(String string) {
        this.req.generatePdfForms = string != null && string.equalsIgnoreCase("true");
    }

    public void setDefaultTTFs(String string, String string2, String string3) {
        this.req.defaultSerif = string;
        this.req.defaultSansSerif = string2;
        this.req.defaultMonospace = string3;
    }

    public void setFooter(PD4PageMark pD4PageMark) {
        if (this.req.footer != null) {
            this.req.footer.setAreaHeight(pD4PageMark.getAreaHeight());
            this.req.footer.setColor(pD4PageMark.getColor());
            this.req.footer.setFont(pD4PageMark.getFont());
            this.req.footer.setFontSize(pD4PageMark.getFontSize());
            this.req.footer.setInitialPageNumber(pD4PageMark.getInitialPageNumber());
            this.req.footer.setPageNumberAlignment(pD4PageMark.getPageNumberAlignment());
            this.req.footer.setPageNumberTemplate(pD4PageMark.getPageNumberTemplate());
            this.req.footer.setPagesToSkip(pD4PageMark.getPagesToSkip());
            this.req.footer.setTitleAlignment(pD4PageMark.getTitleAlignment());
            this.req.footer.setTitleTemplate(pD4PageMark.getTitleTemplate());
            this.req.footer.setHtmlTemplate(pD4PageMark.getHtmlTemplate());
        } else {
            this.req.footer = pD4PageMark;
        }
    }

    public void setHeader(PD4PageMark pD4PageMark) {
        if (this.req.header != null) {
            this.req.header.setAreaHeight(pD4PageMark.getAreaHeight());
            this.req.header.setColor(pD4PageMark.getColor());
            this.req.header.setFont(pD4PageMark.getFont());
            this.req.header.setFontSize(pD4PageMark.getFontSize());
            this.req.header.setInitialPageNumber(pD4PageMark.getInitialPageNumber());
            this.req.header.setPageNumberAlignment(pD4PageMark.getPageNumberAlignment());
            this.req.header.setPageNumberTemplate(pD4PageMark.getPageNumberTemplate());
            this.req.header.setPagesToSkip(pD4PageMark.getPagesToSkip());
            this.req.header.setTitleAlignment(pD4PageMark.getTitleAlignment());
            this.req.header.setTitleTemplate(pD4PageMark.getTitleTemplate());
            this.req.header.setHtmlTemplate(pD4PageMark.getHtmlTemplate());
        } else {
            this.req.header = pD4PageMark;
        }
    }

    public void setPermissions(String string, int n, boolean bl) {
        this.req.password = string;
        this.req.permissions = n;
        this.req.strong = bl;
    }

    public String getEnable() {
        return "" + this.enable;
    }

    public void setEnable(String string) {
        this.enable = "true".equalsIgnoreCase(string);
    }

    public boolean isFitPageVertically() {
        return this.req.fitPageVertically;
    }

    public void setFitPageVertically(boolean bl) {
        this.req.fitPageVertically = bl;
    }

    public boolean isProtectPhysicalUnitDimensions() {
        return this.req.protectPhysicalUnitDimensions;
    }

    public void setProtectPhysicalUnitDimensions(boolean bl) {
        this.req.protectPhysicalUnitDimensions = bl;
    }

    public String getMulticolumn() {
        return this.req.multicolumn;
    }

    public void setMulticolumn(String string) {
        this.req.multicolumn = string;
    }

    public String getOutputRange() {
        return this.req.outputRange;
    }

    public void setOutputRange(String string) {
        this.req.outputRange = string;
    }

    public String getOutputFormat() {
        return this.req.outputFormat;
    }

    public void setOutputFormat(String string) {
        this.req.outputFormat = string;
    }

    public void setSaveFile(String string, String string2, String string3, String string4, String string5, boolean bl) throws JspException {
        this.redirectMethod = string5;
        File file = new File(string);
        if (file.exists()) {
            if (bl) {
                System.out.println("directory [" + string + "] exists");
            }
        } else if (bl) {
            System.out.println("directory [" + string + "] does not exist, creating...");
            if (!file.mkdir()) {
                throw new JspException("can not open or create: [" + string + "]");
            }
        }
        try {
            if (string3 != null && string3.length() > 0 && !string3.equals(".") && !string3.equals("..")) {
                this.savePdfToFile = new File(file, string3);
            }
            if (this.savePdfToFile != null && this.savePdfToFile.exists()) {
                if (bl) {
                    System.out.println("[" + this.savePdfToFile.getPath() + "] exists; adding random number to the name...");
                }
                if (string3 == null) {
                    string3 = "pd4";
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ".");
                String string6 = stringTokenizer.nextToken();
                String string7 = ".pdf";
                if (stringTokenizer.hasMoreTokens()) {
                    string7 = "." + stringTokenizer.nextToken();
                }
                this.savePdfToFile = File.createTempFile(string6 + "___".substring(0, Math.max(0, 3 - string6.length())), string7, file);
            }
            if (this.savePdfToFile == null) {
                this.savePdfToFile = File.createTempFile("pd4", ".pdf", file);
            }
            if (bl) {
                System.out.println("[" + this.savePdfToFile.getPath() + "] created.");
            }
        }
        catch (IOException iOException) {
            throw new JspException("can not create: [" + string + "/" + string3 + "]");
        }
        if (string4 != null && string4.length() > 0 && !string4.toLowerCase().equals("disabled")) {
            this.redirectToSavedFile = string4.toLowerCase().equals("pdf") ? string2 + "/" + this.savePdfToFile.getName() : string4 + (string4.indexOf("?") >= 0 ? "&" : "?") + "filename=" + this.savePdfToFile.getName();
        }
        if (bl) {
            System.out.println("set redirect to [" + this.redirectToSavedFile + "].");
        }
    }
}

