/*
 * Decompiled with CFR 0.152.
 */
package com.pd4ml;

import com.pd4ml.Dimensions;

public class PageMargins
implements Dimensions {
    public static final PageMargins DEFAULT_PAGE_MARGINS = new PageMargins(10.0f, 10.0f, 10.0f, 10.0f, Dimensions.Units.MM);
    public float left;
    public float top;
    public float right;
    public float bottom;

    public PageMargins(float f2, float f3, float f4, float f5) {
        this.left = f2;
        this.top = f3;
        this.right = f4;
        this.bottom = f5;
    }

    public PageMargins(float f2, float f3, float f4, float f5, Dimensions.Units units) {
        switch (units) {
            case PT: {
                this.left = f2;
                this.top = f3;
                this.right = f4;
                this.bottom = f5;
                break;
            }
            case MM: {
                this.left = f2 * 2.835f;
                this.top = f3 * 2.835f;
                this.right = f4 * 2.835f;
                this.bottom = f5 * 2.835f;
                break;
            }
            case PX: {
                this.left = f2 / 1.35f;
                this.top = f3 / 1.35f;
                this.right = f4 / 1.35f;
                this.bottom = f5 / 1.35f;
            }
        }
    }

    public PageMargins flipHorizontal() {
        return new PageMargins(this.right, this.top, this.left, this.bottom);
    }

    public PageMargins flipVertical() {
        return new PageMargins(this.left, this.bottom, this.right, this.top);
    }

    public String toString() {
        return "l:" + this.left + ", t:" + this.top + ", r:" + this.right + ", b:" + this.bottom;
    }

    public PageMargins rotate() {
        return new PageMargins(this.top, this.right, this.bottom, this.left);
    }
}

