/*
 * Decompiled with CFR 0.152.
 */
package com.pd4ml;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class PdfSpec {
    public static final PdfSpec PDF_1_0 = new PdfSpec("1.0", 100);
    public static final PdfSpec PDF_1_1 = new PdfSpec("1.1", 110);
    public static final PdfSpec PDF_1_2 = new PdfSpec("1.2", 120);
    public static final PdfSpec PDF_1_3 = new PdfSpec("1.3", 130);
    public static final PdfSpec PDF_1_4 = new PdfSpec("1.4", 140);
    public static final PdfSpec PDF_1_5 = new PdfSpec("1.5", 150);
    public static final PdfSpec PDF_1_6 = new PdfSpec("1.6", 160);
    public static final PdfSpec PDF_1_7 = new PdfSpec("1.7", 170);
    public static final PdfSpec PDF_1_7_1 = new PdfSpec("1.7ext1", 171);
    public static final PdfSpec PDF_1_7_2 = new PdfSpec("1.7ext2", 172);
    public static final PdfSpec PDF_1_7_3 = new PdfSpec("1.7ext3", 173);
    public static final PdfSpec PDF_1_7_4 = new PdfSpec("1.7ext4", 174);
    public static final PdfSpec PDF_1_7_5 = new PdfSpec("1.7ext5", 175);
    public static final PdfSpec PDF_1_7_6 = new PdfSpec("1.7ext6", 176);
    public static final PdfSpec PDF_1_7_7 = new PdfSpec("1.7ext7", 177);
    public static final PdfSpec PDF_1_7_8 = new PdfSpec("1.7ext8", 178);
    public static final PdfSpec PDF_1_7_9 = new PdfSpec("1.7ext9", 179);
    public static final PdfSpec PDF_1_7_10 = new PdfSpec("1.7ext10", 180);
    public static final PdfSpec PDF_1_7_11 = new PdfSpec("1.7ext11", 181);
    public static final PdfSpec PDF_2_0 = new PdfSpec("2.0", 200);
    public static final PdfSpec PDFA_1A = new PdfSpec("PDF/A-1a:2005", 1);
    public static final PdfSpec PDFA_1B = new PdfSpec("PDF/A-1b:2005", 2);
    public static final PdfSpec PDFA_2A = new PdfSpec("PDF/A-2a", 3);
    public static final PdfSpec PDFA_2B = new PdfSpec("PDF/A-2b", 4);
    public static final PdfSpec PDFA_2U = new PdfSpec("PDF/A-2u", 5);
    public static final PdfSpec PDFA_3A = new PdfSpec("PDF/A-3a", 6);
    public static final PdfSpec PDFA_3B = new PdfSpec("PDF/A-3b", 7);
    public static final PdfSpec PDFA_3U = new PdfSpec("PDF/A-3u", 8);
    public static final PdfSpec PDFA_4 = new PdfSpec("PDF/A-4", 9);
    public static final PdfSpec PDFA_4E = new PdfSpec("PDF/A-4e", 10);
    public static final PdfSpec PDFUA_1 = new PdfSpec("PDF/UA-1", 21);
    public static final PdfSpec PDFUA_2 = new PdfSpec("PDF/UA-2", 22);
    public static final PdfSpec ZUGFeRD = new PdfSpec("ZUGFeRD", 170, 128);
    public static final PdfSpec ZUGFeRD_a = new PdfSpec("ZUGFeRD (tagged)", 170, 64);
    public static final PdfSpec FacturX = new PdfSpec("Factur-X", 170, 128);
    public static final PdfSpec FacturX_a = new PdfSpec("Factur-X (tagged)", 170, 64);
    public String name;
    public int id;
    public int xid = 0;

    private PdfSpec(String string, int n2) {
        this.name = string;
        this.id = n2;
        this.xid = n2 < 100 ? 1 << n2 : 0;
    }

    private PdfSpec(String string, int n2, int n3) {
        this.name = string;
        this.id = n2;
        this.xid = n3;
    }

    public String toString() {
        return this.name;
    }

    public PdfSpec(PdfSpec pdfSpec) throws _c, _b {
        if (pdfSpec.id >= PdfSpec.PDF_1_0.id && pdfSpec.id < PdfSpec.PDF_1_4.id) {
            throw new _b("The requested PDF standard is obsolete and not supported.");
        }
        if (pdfSpec.id >= PdfSpec.PDF_1_4.id && pdfSpec.id <= PdfSpec.PDF_2_0.id) {
            this.name = pdfSpec.name;
            this.id = pdfSpec.id;
        } else if (pdfSpec.isPdfa()) {
            if (pdfSpec.isPdfa1()) {
                this.name = PdfSpec.PDF_1_4.name;
                this.id = PdfSpec.PDF_1_4.id;
            } else if (pdfSpec.isPdfa23()) {
                this.name = PdfSpec.PDF_1_7.name;
                this.id = PdfSpec.PDF_1_7.id;
            } else {
                this.name = PdfSpec.PDF_2_0.name;
                this.id = PdfSpec.PDF_2_0.id;
            }
            this.xid = 1 << pdfSpec.id;
        } else if (pdfSpec.isPdfua1()) {
            this.name = PdfSpec.PDF_1_4.name;
            this.id = PdfSpec.PDF_1_4.id;
            this.xid = 1 << pdfSpec.id;
        } else if (pdfSpec.isPdfua2()) {
            this.name = PdfSpec.PDF_2_0.name;
            this.id = PdfSpec.PDF_2_0.id;
            this.xid = 1 << pdfSpec.id;
        } else {
            throw new _b("The requested PDF standard is unknown.");
        }
    }

    public PdfSpec combine(PdfSpec pdfSpec) throws _c, _b {
        if (pdfSpec.id >= PdfSpec.PDF_1_0.id && pdfSpec.id < PdfSpec.PDF_1_4.id) {
            throw new _b("The requested PDF standard is obsolete and not supported.");
        }
        if (pdfSpec.id >= PdfSpec.PDF_1_4.id && pdfSpec.id <= PdfSpec.PDF_2_0.id) {
            throw new _c("It is not possible to change an already assigned PDF standard " + this.id);
        }
        if (pdfSpec.isPdfa()) {
            if (pdfSpec.isPdfa1() && this.id < PdfSpec.PDF_1_4.id) {
                throw new _c("The requested PDF/A version requires PDF1.4 or newer. Current PDF spec: " + this.id);
            }
            if (pdfSpec.isPdfa23() && this.id < PdfSpec.PDF_1_7.id) {
                throw new _c("The requested PDF/A version requires PDF1.7 or newer. Current PDF spec: " + this.id);
            }
            if (pdfSpec.isPdfa4() && this.id < PdfSpec.PDF_2_0.id) {
                throw new _c("The requested PDF/A version requires PDF2.0 or newer. Current PDF spec: " + this.id);
            }
        } else {
            if (pdfSpec.isPdfua1() && this.id < PdfSpec.PDF_1_4.id) {
                throw new _c("The requested PDF/UA version requires PDF1.4 or newer. Current PDF spec: " + this.id);
            }
            if (pdfSpec.isPdfua2() && this.id < PdfSpec.PDF_2_0.id) {
                throw new _c("The requested PDF/UA version requires PDF2.0 or newer. Current PDF spec: " + this.id);
            }
            if (pdfSpec.isPdfua2() && this.isPdfa123()) {
                throw new _c("Cannot combine PDF/UA-2 with PDF/A-1, PDF/A-2 or PDF/A-3");
            }
        }
        if (!pdfSpec.isPdfa123a() && this.isPdfua()) {
            throw new _c("can combine PDF/UA with PDF/A-a only");
        }
        if (this.isPdfa123a() && !pdfSpec.isPdfua()) {
            throw new _c("PDF/A-" + this.getPdfaVersion() + "a level already defined");
        }
        if (this.isPdfa123b() && pdfSpec.isPdfua()) {
            throw new _c("cannot combine PDF/A-" + this.getPdfaVersion() + "b and " + pdfSpec.name);
        }
        if (this.isPdfa123b()) {
            throw new _c("PDF/A-" + this.getPdfaVersion() + "b level already defined");
        }
        try {
            PdfSpec pdfSpec2 = (PdfSpec)this.clone();
            pdfSpec2.xid |= 1 << pdfSpec.id;
            return pdfSpec2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return new PdfSpec(this.name, this.id, this.xid);
    }

    private static boolean o00000(PdfSpec pdfSpec) {
        return pdfSpec.id == PdfSpec.PDFA_1A.id || pdfSpec.id == PdfSpec.PDFA_1B.id;
    }

    private static boolean \u00d200000(PdfSpec pdfSpec) {
        return pdfSpec.id >= PdfSpec.PDFA_2A.id && pdfSpec.id <= PdfSpec.PDFA_2U.id;
    }

    private static boolean String(PdfSpec pdfSpec) {
        return pdfSpec.id >= PdfSpec.PDFA_3A.id && pdfSpec.id <= PdfSpec.PDFA_3U.id;
    }

    private static boolean \u00d300000(PdfSpec pdfSpec) {
        return pdfSpec.id == PdfSpec.PDFA_4.id || pdfSpec.id == PdfSpec.PDFA_4E.id;
    }

    public boolean isPdfa() {
        return (this.xid & 0xFFFF) != 0;
    }

    public boolean isPdfa1() {
        return (this.xid & 6) != 0;
    }

    public boolean isPdfa1a() {
        return (this.xid & 2) != 0;
    }

    public boolean isPdfa1b() {
        return (this.xid & 4) != 0;
    }

    public boolean isPdfa2() {
        return (this.xid & 0x38) != 0;
    }

    public boolean isPdfa3() {
        return (this.xid & 0x1C0) != 0;
    }

    public boolean isPdfa12() {
        return (this.xid & 0x3E) != 0;
    }

    public boolean isPdfa12a() {
        return (this.xid & 0xA) != 0;
    }

    public boolean isPdfa2u() {
        return (this.xid & 0x20) != 0;
    }

    public boolean isPdfa123() {
        return (this.xid & 0x1FE) != 0;
    }

    public boolean isPdfa123a() {
        return (this.xid & 0x4A) != 0;
    }

    public boolean isPdfa23() {
        return (this.xid & 0x1F8) != 0;
    }

    public boolean isPdfa23a() {
        return (this.xid & 0x48) != 0;
    }

    public boolean isPdfa23b() {
        return (this.xid & 0x90) != 0;
    }

    public boolean isPdfa23u() {
        return (this.xid & 0x120) != 0;
    }

    public boolean isPdfa123b() {
        return (this.xid & 0x94) != 0;
    }

    public boolean isPdfa4e() {
        return (this.xid & 0x400) != 0;
    }

    public boolean isPdfa4f() {
        return (this.xid & 0x800) != 0;
    }

    public boolean isPdfa4() {
        return (this.xid & 0xE00) != 0;
    }

    public boolean isPdfa1234() {
        return (this.xid & 0xFFE) != 0;
    }

    public boolean isPdfa234() {
        return (this.xid & 0xFF8) != 0;
    }

    public boolean isPdfua() {
        return (this.xid & 0x600000) != 0;
    }

    public boolean isPdfua1() {
        return (this.xid & 0x200000) != 0;
    }

    public boolean isPdfua2() {
        return (this.xid & 0x400000) != 0;
    }

    public boolean allowsTransparency() {
        return !this.isPdfa1();
    }

    public boolean allowsAttachments() {
        return !this.isPdfa12();
    }

    public boolean allowsDocLevelAttachments() {
        return this.isPdfa3() || this.id >= PdfSpec.PDF_2_0.id;
    }

    public boolean allowsEncryption() {
        return !this.isPdfa1234();
    }

    public boolean allowsPdfForms() {
        return !this.isPdfa1234();
    }

    public boolean requiresTagging() {
        return this.isPdfa123a() || this.isPdfua();
    }

    public boolean requiresColorspace() {
        return this.isPdfa123b() || this.isPdfa23u() || this.isPdfa4();
    }

    public boolean requiresMetadata() {
        return this.isPdfa() || this.isPdfua();
    }

    public boolean requiresOutputInternet() {
        return this.isPdfa() || this.isPdfua();
    }

    public boolean allowsExternalHyperlinking() {
        return true;
    }

    public boolean requiresReliableUnicodeSemantics() {
        return this.isPdfa1();
    }

    public String getPdfVersionLabel() {
        int n2 = this.id / 10;
        if (n2 == 18) {
            return "1.7";
        }
        if (n2 == 20) {
            return "2.0";
        }
        return "1." + (n2 - 10);
    }

    public int getPdfExtLevel() {
        int n2 = this.id / 10;
        if (n2 == 17 || this.id == 180 || this.id == 181) {
            return this.id - 170;
        }
        return 0;
    }

    public int getPdfaVersion() {
        if (this.isPdfa1()) {
            return 1;
        }
        if (this.isPdfa2()) {
            return 2;
        }
        if (this.isPdfa3()) {
            return 3;
        }
        if (this.isPdfa4()) {
            return 4;
        }
        return 0;
    }

    public int getPdfuaVersion() {
        if (this.id == PdfSpec.PDFUA_1.id) {
            return 1;
        }
        if (this.id == PdfSpec.PDFUA_2.id) {
            return 2;
        }
        return 0;
    }

    private static boolean o00000(PdfSpec pdfSpec, PdfSpec pdfSpec2) {
        return pdfSpec.id < PdfSpec.PDF_1_7.id && pdfSpec2.isPdfa4();
    }

    private static boolean \u00d200000(PdfSpec pdfSpec, PdfSpec pdfSpec2) {
        return pdfSpec.isPdfua2() && pdfSpec2.isPdfa123() || pdfSpec2.isPdfua2() && pdfSpec.isPdfa123();
    }

    public static boolean areCompatible(PdfSpec pdfSpec, PdfSpec pdfSpec2, PdfSpec pdfSpec3) {
        if (pdfSpec != null) {
            if (pdfSpec2 != null && PdfSpec.o00000(pdfSpec, pdfSpec2)) {
                return false;
            }
            if (pdfSpec3 != null && PdfSpec.o00000(pdfSpec, pdfSpec3)) {
                return false;
            }
            if (pdfSpec2 != null && pdfSpec3 != null && PdfSpec.\u00d200000(pdfSpec2, pdfSpec3)) {
                return false;
            }
        } else if (pdfSpec2 != null && pdfSpec3 != null && PdfSpec.\u00d200000(pdfSpec2, pdfSpec3)) {
            return false;
        }
        return true;
    }

    public static PdfSpec getByLabel(String string) {
        if (string == null || string.length() != 3) {
            return PDF_1_7;
        }
        for (Field field : PdfSpec.class.getDeclaredFields()) {
            int n2 = field.getModifiers();
            try {
                if (!Modifier.isStatic(n2) || !Modifier.isFinal(n2) || !((PdfSpec)field.get(null)).getPdfVersionLabel().equals(string)) continue;
                return (PdfSpec)field.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                exception.printStackTrace();
            }
        }
        return PDF_1_7;
    }

    public static PdfSpec getInstance(String string) {
        if (string == null) {
            return PDF_1_7;
        }
        for (Field field : PdfSpec.class.getDeclaredFields()) {
            int n2 = field.getModifiers();
            try {
                if (!Modifier.isStatic(n2) || !Modifier.isFinal(n2) || !((PdfSpec)field.get(null)).toString().equalsIgnoreCase(string)) continue;
                return (PdfSpec)field.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                exception.printStackTrace();
            }
        }
        return PDF_1_7;
    }

    public static PdfSpec getByID(int n2) {
        if (n2 < 1 || n2 > PdfSpec.PDFUA_2.id) {
            return null;
        }
        for (Field field : PdfSpec.class.getDeclaredFields()) {
            int n3 = field.getModifiers();
            try {
                if (!Modifier.isStatic(n3) || !Modifier.isFinal(n3) || ((PdfSpec)field.get(null)).id != n2) continue;
                return (PdfSpec)field.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static String listKeywords() {
        String string = "";
        for (Field field : PdfSpec.class.getDeclaredFields()) {
            int n2 = field.getModifiers();
            try {
                if (!Modifier.isStatic(n2) || !Modifier.isFinal(n2) || ((PdfSpec)field.get(null)).id < PdfSpec.PDF_1_4.id && ((PdfSpec)field.get(null)).id >= PdfSpec.PDF_1_0.id) continue;
                String string2 = ((PdfSpec)field.get(null)).toString();
                if (((PdfSpec)field.get(null)).id >= PdfSpec.PDF_1_4.id && !string2.startsWith("Z") && !string2.startsWith("F")) {
                    string = string + "'PDF" + string2 + "' ";
                    continue;
                }
                string = string + "'" + string2 + "' ";
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                exception.printStackTrace();
            }
        }
        return string;
    }

    public static class _b
    extends IOException {
        public _b(String string) {
            super(string);
        }
    }

    public static class _c
    extends IOException {
        public _c(String string) {
            super(string);
        }
    }
}

